﻿using System;
using System.Threading;
using System.Threading.Tasks;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using IMP.PhosphoRS;

namespace IMP.PhosphoSampleDatasource 
{
    class SampleDatasource : ThreadManagement.IDataConection
    {

        private const double masstolerance = 0.02;
        private const int phosphorilationSymbol = 1;
        private const int maxIsoformCount = 200;
        private const int maxPTMCount = 20;
        private const int maxPackageSize = 3000;
        private const string scoreNLToo = "true";
        private AminoAcidModification scoredAA;
        private int totalNumberOfSpectra;

        private List<Tuple<PeptideSpectrumMatch, List<Tuple<int, List<int>>>>> items;
        public IDictionary<int, double> propMap;
        public IDictionary<int, double> peptideScoreMap;
        public IDictionary<int, string> sitepropMap;
        public IDictionary<int, string> sequenceStringMap;
        public void start()
        {
            sequenceStringMap = new Dictionary<int, String>();
            items = new List<Tuple<PeptideSpectrumMatch, List<Tuple<int, List<int>>>>>();

            List<AminoAcidModification> modifications;
            PeptideSpectrumMatch psm;
            List<Peak> peaks;
            AminoAcidSequence AAS;
            List<Tuple<int,List<int>>> id2ModMap;

            modifications = new List<AminoAcidModification>(1);

            // perhabs some words. We now create the possible modifications. 
            // the first parameter is a char (it can be Anything, but has to be the same as in the modification map (see AminoacidSequence below)
            // the second is the name. Also this one can be anything
            // third is short sign. can be anyting as the next one..
            // after that the delta mass, here 80 (phos)
            // neutralloss mass
            // Target Aminoacid of defined modification
            modifications.Add(new AminoAcidModification('1',"Phosphorylation","Pho","H3PO4",80,98,AminoAcidSequence.ParseAASequence("STY")));

            //generate a list of peaks is quite simple. ParsePeaks uses a String in en-us format (see msdn http://msdn.microsoft.com/en-us/library/system.iformatprovider.aspx)
            peaks = Peak.ParsePeaks("147.112790:1.57e+04,260.196930:2.233e+04,335.098210:8461,490.286930:2.259e+04,585.288330:2.135e+04,619.798400:2.756e+04,732.407290:5492,819.445310:1.118e+04,934.473450:6095,1031.525150:1.353e+04,1169.571040:2581,1267.551270:669.9,1452.623410:654.4,129.102330:1.238e+04,208.083549:6208,352.125270:8340,474.229980:4592,585.788570:1.203e+04,620.300290:1.794e+04,716.269600:4138,820.445250:3155,935.480220:2000,1032.527830:6714,1152.546260:1971,145.060730:9882,232.092650:5698,371.228970:6425,491.289890:4077,550.776860:8125,668.787720:9707,731.810670:3589,847.293520:1230,911.356320:810.1,1100.541260:1967,1170.566770:1409,130.087283:8799,283.103610:4881,389.239350:6221,420.151120:3751,516.265690:5717,603.370910:9630,749.337765:3244,893.369810:1136,991.330570:681.1,1013.512450:1854,1153.561400:954.1,117.066020:4001,282.108520:2578,370.135990:4451,427.206300:1200,551.279420:4070,691.825380:7560,740.809570:2201,867.422420:910.5,979.368770:679.7,1101.546140:864.4,1123.449460:654.5,197.078910:3073,242.185970:2566,351.131320:2776,468.109310:1157,518.128360:2922,669.288570:5662,741.310360:1501,860.253970:829.4,916.466670:678,1014.508420:816.9,1105.477540:564.4,175.118710:2564,214.081860:2479,306.048490:2173,429.162660:1089,599.284850:2913,692.324650:5371,733.420100:1478,892.362000:821.2,961.401060:643.5,110.071450:2532,261.200160:2032,334.113710:1871,432.092530:894.1,576.285030:2329,682.817690:5277,734.197810:995.1,832.339900:656.2,930.330440:535.4,187.094446:2408,236.102830:1961,344.183290:1446,450.105620:797,516.767150:2068,611.291810:4306,763.329530:970,833.340520:625.6,186.087230:2233,277.130980:1865,305.125210:905.3,438.157530:707.8,567.208740:1778,683.322020:4146,749.885740:968.3,878.259890:592,102.055150:1638,102.806820:482,111.055710:713.8,120.080610:1556,136.076450:1080,139.049380:1106,142.123000:482.2,146.065080:549.2,148.116760:455.8,157.061080:810.6,167.081630:658.3,169.061020:807.7,183.149440:1613,184.070130:483.7,185.092410:496.3,196.072280:1110,199.086244:1309,201.123400:479.7,204.097120:1251,210.083440:583.9,213.086750:1850,215.139140:1170,226.082520:1671,227.099700:571,231.097050:1848,238.080120:473.3,265.092830:1392,273.122100:605,284.104710:494.9,300.119200:783.6,301.113490:1850,326.172060:859.1,379.126130:703.8,390.242070:541.1,399.091000:895.9,472.277400:614.4,480.169860:541,489.178620:581.8,507.184940:926.5,514.242370:597.8,515.263790:612.6,541.771790:1114,542.242130:1126,549.197630:1618,556.261350:612.5,560.261540:584.5,564.199280:506,568.210880:509.6,576.782590:1407,582.599790:980.1,590.278140:1093,597.287480:794.9,599.785950:1774,602.287110:636.8,604.374080:2209,604.796450:1029,605.282230:532.2,605.800350:1984,606.303470:902.8,610.794430:3456,611.786070:945.6,613.802860:924.8,618.214900:1062,619.213680:564.8,628.804870:1731,629.302920:1079,634.275210:939.5,636.226260:2145,644.172180:594.5,646.282780:709.7,651.267940:736.8,657.325620:727,659.783570:796.7,660.280700:1391,662.181580:1192,665.285160:596,673.823000:937.4,674.304200:1114,676.815000:1008,677.789980:2106,678.291140:1759,680.284730:1095,700.830510:2185,701.334230:2377,714.416810:539,717.336550:721.8,731.324220:645,750.297360:646.6,754.316470:652.6,761.308780:652.3,772.333680:641.2,780.264950:710.3,798.337520:952.3,801.441470:740.9");
            //We now generate the wanted AminoAcid Sequence. 
            AAS = AminoAcidSequence.Create(1, "SGSSSPDSEITELK", modifications, "0.00011000000000.0");
            //Here we generate a Peptide Spectrum match. The arguments are:
            //ID, activicationtype, charge state,precursor mass (is not needed, can be anything), peak array,AAS
            psm = new PeptideSpectrumMatch(1, SpectrumType.HCD, 2, 1500, peaks.ToArray(), AAS);

            //phosophoRS itself calculates all position isoforms, given one representativ. 
            //With this list, it is possible to output the data for some positions isoforms.
            //The first argument is a peptide id, the second a List of scored mod positions.
            id2ModMap = new List<Tuple<int,List<int>>>();
            int peptideID;
            peptideID =1;
            sequenceStringMap.Add(peptideID, AAS.ToOneLetterCodeString());
            id2ModMap.Add( new Tuple<int,List<int>>(peptideID,new List<int>{3,4})); //this index is null based!!
            peptideID =2;
            sequenceStringMap.Add(peptideID, AAS.ToOneLetterCodeString());
            id2ModMap.Add(new Tuple<int, List<int>>(peptideID, new List<int> { 2, 4 }));

            items.Add(new Tuple<PeptideSpectrumMatch,List<Tuple<int,List<int>>>>(psm,id2ModMap));

            //initialize the Threadmanagement.
            scoredAA = modifications[0];
            totalNumberOfSpectra = 1;

            var m_searchCancel = new CancellationTokenSource();

            //Nothing fancy here just a blockingcollection with FIFO
            progressMessageQueue = new BlockingCollection<ThreadManagement.progressMessage>(new ConcurrentQueue<ThreadManagement.progressMessage>());

            //This task listen to this collection and takes any message that is send... 
            Task t2 = Task.Factory.StartNew(() =>
            {
                try
                {
                    ThreadManagement.progressMessage msg;
                    double lastProgress;

                    lastProgress = -1;
                    while (!progressMessageQueue.IsCompleted)
                    {
                        msg = progressMessageQueue.Take();
                        if (msg.type == ThreadManagement.progressMessage.typeOfMessage.stringMessage)
                        {
                            if (msg.message != null)
                            {
                                //here the string message can be used to for output. 
                                //print(msg.message)
                            }
                        }
                        else
                        {
                            //spectraProcessed is not a integer. 
                            //see GetNewDataPackage. 
                            //after each spetra this funtion will be called (asynchronously). 
                            var currentProgress = msg.spectraProcessed / totalNumberOfSpectra;

                            if (currentProgress >= lastProgress + 0.001)
                            {//just send progress reports in 1% steps... 
                                lastProgress = currentProgress;
                                //use this data to print the progress in a progress bar. 
                                //print_progress(lastprogress * 100);
                            }
                        }
                    }
                }
                catch (Exception)
                {
                }
            });

            var phosphoRS3 = new ThreadManagement(this,  m_searchCancel,maxIsoformCount, maxPTMCount, scoreNLToo, masstolerance, scoredAA, totalNumberOfSpectra);

            //This function uses the current thread. 
            phosphoRS3.StartPTMLocalisation();

            //get results:
            propMap = phosphoRS3.PTMResult.PeptideIdPrsProbabilityMap;
            peptideScoreMap = phosphoRS3.PTMResult.PeptideIdPrsScoreMap;
            sitepropMap = phosphoRS3.PTMResult.PeptideIdPrsSiteProbabilitiesMap;
        }

        int currentNr = 0;
        List<ThreadManagement.SpectraPackageItem> ThreadManagement.IDataConection.GetNewDataPackage(int maxSizeOfPackage, out int numberOfSpectraPacked, out int numberOfPeptidesPacked) 
        {
            //This function will be called when a new package is needed:
            //A package is needed by the threadmangement when the calculated
            //number of threads is not working. The number of threads depends
            //on the number of processors and if x86 or x64. 
            //in one package there are maxSizeOfPackage of spectrapackages
            List<ThreadManagement.SpectraPackageItem> package;

            numberOfSpectraPacked = 0;
            numberOfPeptidesPacked = 0;
            if (currentNr >= items.Count)
                return null;

            package = new List<ThreadManagement.SpectraPackageItem>();
            for (int i = currentNr; i < items.Count && i - currentNr < maxSizeOfPackage; i++)
            {
                // After starting the threads phosphoRS will through this 
                // function try to get a new PSM package. 
                // The arguments are: Peptide Spectrum Match, 
                // Number of spectra used to create this package. This number is smaller or equal 1. It is used to calculate the progress. 
                // Example: 1 Spectra, n different peptides. Therefore, n spectraPackageItems. The spectra count is therefore 1/n. (n stands for an natural number (= 1,2,3,4,....)
                package.Add(new ThreadManagement.SpectraPackageItem(items[i].Item1,1/items.Count, items[i].Item2));
            }

            currentNr += package.Count;
            numberOfSpectraPacked = package.Count;
            numberOfPeptidesPacked = package.Count;

            return package;
        }

        private BlockingCollection<ThreadManagement.progressMessage> progressMessageQueue;

        BlockingCollection<ThreadManagement.progressMessage> ThreadManagement.IDataConection.GetProgressMessageQueue()
        {
            return progressMessageQueue;
        }

    }
}
